% finaquant Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu 2012, version: 12July2012
% Download at:
% http://finaquant.com/download
% Email: fqcontact@finaquant.com
function TestData = generate_hierarchy_attribute_combinations(ListAttributeValues, AttributeNames)
% Generate test data (cell matrix) as cartesian multiplication of 
% dependent attribute values from a hierarchy
% Input argument ListAttributeValues is a cell array containing the list
% of hierarchical attribute values, for example:
%
% AttributeNames = {'Origin', 'Car', 'Model'}
%
% first attribute pair in hierarchy: Origin-Car
% ListAttributeValues{1} = {'Germany', 'Germany', 'Japan', 'Japan'}
% ListAttributeValues{2} = {'Audi', 'Mercedes', 'Toyota', 'Honda'}
%
% second attribute pair in hierarchy: Car-Model
% ListAttributeValues{3} = {'Audi','Audi','Mercedes','Mercedes','Toyota','Toyota','Honda'}
% ListAttributeValues{4} = {'A1', 'A2', 'M25', 'M50', 'TX1', 'TY1', 'H15'}

% check array sizes
if length(ListAttributeValues) ~= 2 * (length(AttributeNames)-1)
    error 'Mismatch in the sizes of input arrays!'
end
for i=1:length(AttributeNames)-1
    if length(ListAttributeValues{i*2}) ~= length(ListAttributeValues{i*2-1})
        error 'Mismatch in the array sizes of attribute pairs in hierarchy!'
    end
end

% initiate and set counter limits
CounterLimits = zeros(1, length(AttributeNames)-1);
for i=1:(length(AttributeNames)-1)
    CounterLimits(i) = length(ListAttributeValues{i*2});
end

% obtain all possible attribute value combinations in hierarchy
LimitAchieved = false;
MultiStepCountVec = [];
TestData = {};  % empty cell
TestDataRow = cell(1, length(AttributeNames));

while ~ LimitAchieved
    [MultiStepCountVec, LimitAchieved] = increment_MultiRegister_counter(MultiStepCountVec, CounterLimits); 
    
    
    % check parent-child relationship for all attribute pairs
    AllAttributePairsMatched = 1;
    for i=1:length(MultiStepCountVec)-1
        if strcmp(ListAttributeValues{2*i}{MultiStepCountVec(i)}, ...
            ListAttributeValues{2*i+1}{MultiStepCountVec(i+1)}) ~= 1
            AllAttributePairsMatched = 0;
            break;
        end
    end
    
    if AllAttributePairsMatched == 1
        for i=1:length(MultiStepCountVec)
            TestDataRow{i} = ListAttributeValues{2*i-1}{MultiStepCountVec(i)};
        end
        l = length(AttributeNames);
        TestDataRow{l} = ListAttributeValues{2*(l-1)}{MultiStepCountVec(l-1)};
        TestData = [TestData; TestDataRow];
    end
end
TestData = [AttributeNames; TestData];
